<?php
require_once("../config.php");

$user_id = intval($_POST['user_id'] ?? 0);
$unit_id = intval($_POST['unit_id'] ?? 0);
$start_date = $_POST['start_date'] ?? '';
$days = intval($_POST['days'] ?? 0);
$note = $_POST['note'] ?? '';

if ($user_id<=0 || $unit_id<=0 || $start_date=='' || $days<=0) {
  json_out(["status"=>false, "message"=>"Input booking tidak lengkap"]);
}

$stmt = $conn->prepare("SELECT price_per_day, stock FROM units WHERE id=? LIMIT 1");
$stmt->bind_param("i", $unit_id);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows==0) json_out(["status"=>false, "message"=>"Unit tidak ditemukan"]);

$u = $res->fetch_assoc();
if (intval($u['stock']) <= 0) json_out(["status"=>false, "message"=>"Stok habis"]);

$total = intval($u['price_per_day']) * $days;

$stmt2 = $conn->prepare("INSERT INTO bookings(user_id,unit_id,start_date,days,note,total_price) VALUES (?,?,?,?,?,?)");
$stmt2->bind_param("iisssi", $user_id, $unit_id, $start_date, $days, $note, $total);
$ok = $stmt2->execute();

json_out([
  "status"=>$ok,
  "message"=>$ok ? "Booking berhasil" : "Booking gagal",
  "total_price"=>$total
]);
